<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;

class CleanOldLogs extends Command
{
    protected $signature = 'logs:clean {--days=30}';
    protected $description = 'Clean old log files';

    public function handle()
    {
        $days = $this->option('days');
        $this->info("Cleaning logs older than {$days} days...");

        $logPath = storage_path('logs');
        $files = glob($logPath . '/*.log');
        $cutoffDate = Carbon::now()->subDays($days);
        $count = 0;

        foreach ($files as $file) {
            $lastModified = Carbon::createFromTimestamp(filemtime($file));
            
            if ($lastModified->lt($cutoffDate)) {
                unlink($file);
                $count++;
                $this->info("Deleted: " . basename($file));
            }
        }

        $this->info("Cleaned {$count} log files.");
    }
}
