<?php

namespace App\Http\Controllers;

use App\Http\Requests\ContactFormRequest;
use App\Models\Contact;
use App\Models\Site;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;

class ContactController extends Controller
{
    public function getContactInfo()
    {
        // Cache the results for 1 hour
        $contact = Cache::remember('contact_' . app()->getLocale(), 3600, function () {
            return DB::table('contacts')
                ->where('site', config('app.site_id', '6'))
                ->where('language', app()->getLocale())
                ->first();
        });

        $seo = Cache::remember('seo_' . app()->getLocale(), 3600, function () {
            return DB::table('seos')
                ->where('site', config('app.site_id', '6'))
                ->where('language', app()->getLocale())
                ->first();
        });

        $site = Cache::remember('site', 3600, function () {
            return Site::find(config('app.site_id', '6'));
        });

        // Remote database connection should be handled carefully
        try {
            $city = DB::connection('mysql_rep')->table('iller')->get();
        } catch (\Exception $e) {
            $city = collect([]); // Empty collection if connection fails
            \Log::error('Remote database connection failed: ' . $e->getMessage());
        }

        $education = Cache::remember('education_' . app()->getLocale(), 3600, function () {
            return DB::table('educations')
                ->where('site', config('app.site_id', '6'))
                ->where('language', app()->getLocale())
                ->get();
        });

        return view('contact', compact('contact', 'seo', 'site', 'city', 'education'));
    }

    public function submitContactForm(ContactFormRequest $request)
    {
        try {
            // Form verisi zaten ContactFormRequest tarafından validate edildi
            $contact = Contact::create([
                'name' => strip_tags($request->name),
                'email' => strip_tags($request->email),
                'subject' => strip_tags($request->subject),
                'phone' => strip_tags($request->phone),
                'message' => strip_tags($request->message),
                'site' => config('app.site_id', '6'),
                'language' => app()->getLocale(),
            ]);

            // Cache'i temizle
            Cache::forget('contact_' . app()->getLocale());

            return redirect()
                ->route('contact')
                ->with('success', 'Mesajınız başarıyla gönderildi.');
        } catch (\Exception $e) {
            \Log::error('Contact form submission failed: ' . $e->getMessage());
            
            return redirect()
                ->route('contact')
                ->with('error', 'Mesajınız gönderilirken bir hata oluştu. Lütfen daha sonra tekrar deneyin.');
        }
    }
}