<?php

namespace App\Repositories;

use App\Models\Contact;

class ContactRepository extends BaseRepository
{
    public function __construct(Contact $model)
    {
        parent::__construct($model);
    }

    public function getContactInfo()
    {
        return $this->findWhere([
            'site' => config('app.site_id'),
            'language' => app()->getLocale()
        ]);
    }

    public function createContact(array $data)
    {
        return $this->create(array_merge($data, [
            'site' => config('app.site_id'),
            'language' => app()->getLocale()
        ]));
    }
}
