<?php

namespace App\Repositories;

use App\Models\Quote;

class QuoteRepository extends BaseRepository
{
    public function __construct(Quote $model)
    {
        parent::__construct($model);
    }

    public function createQuote(array $data)
    {
        return $this->create(array_merge($data, [
            'site' => config('app.site_id'),
            'language' => app()->getLocale()
        ]));
    }

    public function isSpam($visitTime): bool
    {
        $currentTime = time();
        return ($currentTime - $visitTime) < 10;
    }
}
