@extends('layouts.app')
@section('css')
@endsection
@section('title')
    Amerikan Kültür Kurumsal
@endsection
@section('content')
    <section class="breadcrumb__area breadcrumb__bg" data-background="{{ asset('assets/img/akdweb.jpg') }}">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="breadcrumb__content">
                        <h2 class="title">{{ __('Blog Details') }}</h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Home') }}</a></li>
                                <li class="breadcrumb-item active" aria-current="page">{{ __('Blog Details') }}</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <div class="breadcrumb__shape">
            <img src="assets/img/images/breadcrumb_shape05.png" alt="" class="alltuchtopdown">
        </div>
    </section>



    <section class="blog__details-area">
        <div class="container">
            <div class="blog__inner-wrap">
                <div class="row">
                    <div class="col-70">
                        <div class="blog__details-wrap">
                            <div class="blog__details-thumb">
                                <img src="{{ config('app.storage') . $blog->image }}" alt="{{ $blog->header }}" height="400px"
                                    width="850px">
                            </div>
                            <div class="blog__details-content">
                                <h2 class="title">{{ $blog->title }}</h2>
                                <div class="blog-post-meta">
                                    <ul class="list-wrap">
                                        <li>
                                            <div class="blog-avatar">

                                            </div>
                                        </li>
                                    </ul>
                                </div>
                                <p>{!! $blog->description !!}</p>
                                <div class="blog__details-inner">
                                    <div class="row align-items-center">
                                        <div class="col-46 order-0 order-lg-2">

                                        </div>
                                        <div class="col-54">

                                        </div>
                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>
                    <div class="col-30">
                        <aside class="blog__sidebar">
                            <div class="sidebar__widget sidebar__widget-two">
                                <div class="sidebar__search">

                                </div>
                            </div>



                            <div class="box-form-quote">
                                <div class="container">
                                    <div class="testimonial__form">
                                        <h2 class="title">{{ __('Application Form') }}</h2>

                                        <form action="{{ route('quote.store') }}" method="POST">
                                            @csrf
                                            <input type="hidden" id="visit_time" name="visit_time" value="">

                                            <div class="form-grp">
                                                <input type="text" name="AdSoyad" placeholder="{{ __('Name-Surname') }}"
                                                    required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="text" name="SirketAdi"
                                                    placeholder="{{ __('Company Name') }}" required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="email" name="KurumsalEposta"
                                                    placeholder="{{ __('Corporate Email') }}" required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="text" name="Telefon" placeholder="{{ __('Phone') }}"
                                                    required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="text" name="Sektor" placeholder="{{ __('Sector') }}"
                                                    required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="number" name="KatilimciSayisi"
                                                    placeholder="{{ __('Number of Participants') }}" required>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="SozlesmeOnayi"
                                                    value="1" id="flexCheckChecked">
                                                <label class="form-check-label" for="flexCheckChecked">
                                                    <a href="{{ route('agreement') }}" target="_blank">
                                                        {{ __('I agree to the KVKK contract') }}
                                                    </a>
                                                </label>
                                            </div>


                                            <button type="submit" id="submitBtn" class="btn"
                                                disabled>{{ __('Submit') }}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <br>
                            <br>




                            <div class="sidebar__widget">
                                <h4 class="sidebar__widget-title">{{ __('Recently Posted') }}</h4>
                                <div class="sidebar__post-list">
                                    @foreach ($blogs as $blog)
                                        <div class="sidebar__post-item">
                                            <div class="sidebar__post-thumb">
                                                <a href="{{ route('blog.show', ['slug' => $blog->slug]) }}">
                                                    <img src="{{ config('app.storage') . $blog->image }}" alt=""
                                                        width="200px">
                                                </a>
                                            </div>
                                            <div class="sidebar__post-content">
                                                <h5 class="title">
                                                    <a href="{{ route('blog.show', ['slug' => $blog->slug]) }}">
                                                        {{ \Illuminate\Support\Str::limit($blog->header, 50) }}
                                                    </a>
                                                </h5>

                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>


                        </aside>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        /* reCAPTCHA boyutunu küçültmek için */
        .g-recaptcha {
            transform: scale(0.90);
            /* Boyut oranını küçültür */
            transform-origin: 0 0;
            /* Sol üstten küçültme başlar */
            margin-top: 15px;
            /* Üstten biraz boşluk */
            margin-left: 0px;
            /* Sol kenardan boşluk */
        }

        .box-form-quote {
            background-color: #fff;
            /* Arka plan rengi */
            border: 1px solid #ddd;
            /* Çizgi */
            padding: 0px;
            /* İç boşluk */
            margin-top: 30px;
            /* Üstten boşluk */
            border-radius: 8px;
            /* Yuvarlatılmış köşeler */
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            /* Hafif gölge efekti */
            display: flex;
            /* Flex kullanıyoruz */
            justify-content: flex-end;
            /* Sağ tarafa yaslamak */
            padding-right: 27px;
            /* Sağ tarafta biraz daha boşluk bırakmak için */
        }

        .testimonial__form {
            width: 100%;
            /* Formun tam genişlikte olmasını sağlıyoruz */
            max-width: 500px;
            /* Formun genişliğini sınırlıyoruz */
            padding: 20px 5px 15px;
        }

        /* Diğer stil ayarları */
        .form-grp {
            margin-bottom: 15px;
        }

        .form-grp input {
            width: 100%;
            padding: 10px;
            margin: 8px 0;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }

        button[type="submit"] {
            background-color: #d73434;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
        }

        button[type="submit"]:hover {
            background-color: #c42a2a;
        }

        button[disabled] {
            background-color: #aaa;
            cursor: not-allowed;
        }
    </style>
@endsection
