@extends('layouts.app')
@section('css')
@endsection
@section('title')
    Amerikan Kültür Kurumsal
@endsection
@section('content')
    <section class="breadcrumb__area breadcrumb__bg" data-background="assets/img/akdweb.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="breadcrumb__content">
                        <h2 class="title">{{ __('Education') }}</h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Home') }}</a></li>
                                <li class="breadcrumb-item active" aria-current="page">{{ __('Education') }}</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <div class="breadcrumb__shape">
            <img src="assets/img/images/breadcrumb_shape05.png" alt="" class="alltuchtopdown">
        </div>
    </section>

    <section class="services__area-five services__bg-five" data-background="assets/img/bg/inner_services_bg02.jpg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-6 col-lg-8">
                    <div class="section-title text-center mb-40">
                        <h2 class="text-center" style="color:#E30613">{{ __('Our Corporate Traınıngs') }}</h2>
                        <p style="color: #29235C">
                            {{ __('Our trainings, which are tailor-made for you in accordance with your goals and level, are organized on the days and times you prefer. We ensure that you achieve success with our flexible training programs for your corporate or individual needs.') }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="services-item-wrap">
                <div class="row justify-content-center">
                    @foreach ($education as $edu)
                        <div class="col-xl-3 col-lg-4 col-md-6 col-sm-8">
                            <div class="services-item shine-animate-item">
                                <div class="services-thumb">
                                    <a class='shine-animate' href="{{ route('education.show', $edu->name) }}">
                                        <img src="{{ config('app.storage') . $edu->image }}" alt="">
                                    </a>
                                </div>
                                <div class="services-content">
                                    <div class="icon">
                                        <img src="assets/img/akd.png" alt="akd">
                                    </div>
                                    <h4 class="title">
                                        <a href="{{ route('education.show', $edu->slug) }}" style="color: #E30613">
                                            {{ $edu->name }}
                                        </a>
                                    </h4>
                                    <p>{!! $edu->title ? Str::limit($edu->title, 100, '...') : '' !!}</p>
                                    <a class='btn'
                                        href="{{ route('education.show', $edu->slug) }}">{{ __('Read More') }}</a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endsection
