@extends('layouts.app')
@section('css')
@endsection
@section('title')
    Amerikan Kültür Kurumsal
@endsection
@section('content')

    <section class="breadcrumb__area breadcrumb__bg" data-background="{{ asset('assets/img/akdweb.jpg') }}">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="breadcrumb__content">
                        <h2 class="title">{{ __('Education Details') }}</h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Home') }}</a></li>
                                <li class="breadcrumb-item active" aria-current="page">{{ __('Education Details') }}</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <div class="breadcrumb__shape">
            <img src="assets/img/images/breadcrumb_shape05.png" alt="" class="alltuchtopdown">
        </div>
    </section>

    <section class="services__details-area">
        <div class="container">
            <div class="services__details-wrap">
                <div class="row">
                    <div class="col-70 order-0 order-lg-2">
                        <div class="services__details-thumb">
                            <img src="{{ config('app.storage') . $education->image }}" alt="">
                        </div>
                        <div class="services__details-content">
                            <h2 class="title" style="color:#E30613;">{{ $education->name }}</h2>
                            <p>{!! $education->description !!}</p>



                            <div class="services__details-inner">
                                <div class="row gutter-24 align-items-center">
                                    <div class="col-44">

                                    </div>
                                    <div class="col-56">

                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="col-30">
                        <aside class="services__sidebar">
                            <div class="sidebar__widget sidebar__widget-two">
                                <div class="sidebar__cat-list-two">
                                    <ul class="list-wrap">
                                        @if ($educations->isNotEmpty())
                                            @foreach ($educations as $related)
                                                <li><a href="{{ route('education.show', ['slug' => $related->slug]) }}">{{ $related->name }}
                                                        <i class="flaticon-arrow-button"></i></a></li>
                                            @endforeach
                                        @else
                                            <li>
                                                <p>{{ __('No other trainings found.') }}</p>
                                            </li>
                                        @endif
                                    </ul>
                                </div>
                            </div>






                            <div class="box-form-quote">
                                <div class="container">
                                    <div class="testimonial__form">
                                        <h2 class="title">{{ __('Application Form') }}</h2>

                                        <form action="{{ route('quote.store') }}" method="POST">
                                            @csrf
                                            <input type="hidden" id="visit_time" name="visit_time" value="">

                                            <div class="form-grp">
                                                <input type="text" name="AdSoyad" placeholder="{{ __('Name-Surname') }}"
                                                    required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="text" name="SirketAdi"
                                                    placeholder="{{ __('Company Name') }}" required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="email" name="KurumsalEposta"
                                                    placeholder="{{ __('Corporate Email') }}" required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="text" name="Telefon" placeholder="{{ __('Phone') }}"
                                                    required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="text" name="Sektor" placeholder="{{ __('Sector') }}"
                                                    required>
                                            </div>
                                            <div class="form-grp">
                                                <input type="number" name="KatilimciSayisi"
                                                    placeholder="{{ __('Number of Participants') }}" required>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="SozlesmeOnayi"
                                                    value="1" id="flexCheckChecked" required>
                                                <label class="form-check-label" for="flexCheckChecked">
                                                    <a href="{{ route('agreement') }}" target="_blank">
                                                        {{ __('I agree to the KVKK contract') }}
                                                    </a>
                                                </label>
                                            </div>


                                            <button type="submit" id="submitBtn" class="btn" disabled>
                                                {{ __('Submit') }}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>

                        </aside>
                    </div>
                </div>
            </div>
        </div>
        <style>
            .box-form-quote {
                background-color: #fff;

                border: 1px solid #ddd;

                padding: 0px;

                margin-top: 30px;

                border-radius: 8px;

                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);

                display: flex;

                justify-content: flex-end;

                padding-right: 27px;

            }

            .testimonial__form {
                width: 100%;

                max-width: 500px;

                padding: 20px 5px 15px;
            }


            .form-grp {
                margin-bottom: 15px;
            }

            .form-grp input {
                width: 100%;
                padding: 10px;
                margin: 8px 0;
                border: 1px solid #ddd;
                border-radius: 4px;
                box-sizing: border-box;
            }

            button[type="submit"] {
                background-color: #d73434;
                color: #fff;
                padding: 10px 20px;
                border: none;
                border-radius: 4px;
                cursor: pointer;
                width: 100%;
            }

            button[type="submit"]:hover {
                background-color: #c42a2a;
            }

            button[disabled] {
                background-color: #aaa;
                cursor: not-allowed;
            }
        </style>
    </section>






@endsection
