<!doctype html>
<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    @php
    $seo = DB::table('seos')->where('site',6)->where('language',app()->getLocale())->first();
    $contact = DB::table('contact_infos')->where('site',6)->where('language',app()->getLocale())->first();
    $agreement = DB::table('agreements')->where('site',6)->where('language',app()->getLocale())->take(6)->get();
    $addvertise = DB::table('advertisings')->where('site',6)->orderBy('id','desc')->where('language',app()->getLocale())->first();
    $site       = DB::table('sites')->whereId('6')->first();

    @endphp
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>@yield('title')</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="{!!html_entity_decode($seo?->description )!!}"/>
    <meta name="author" content="Fatih CELIK">
    <meta name="keywords" content="@php preg_match_all('/"value":"([^"]+)"/', stripslashes(json_decode($seo?->keywords ?? '')), $matches); echo implode(',', $matches[1] ?? []) ?? ''; @endphp">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('assets/img/akdKurumsalwhite.png') }}">
    <!-- Place favicon.ico in the root directory -->
    <!-- CSS here -->
    <link rel="stylesheet" href="{{asset('assets/css/bootstrap.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/animate.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/magnific-popup.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/fontawesome-all.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/flaticon.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/odometer.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/swiper-bundle.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/aos.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/default.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/main.css')}}">
  

    <!-- Swiper CSS -->
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.4.6/css/flag-icon.min.css">
    @yield('css')
</head>
<body>
    <!--Preloader-->
    <div id="preloader">
        <div id="loader" class="loader">
            <div class="loader-container">
                <div class="loader-icon">
                    <img src="{{asset('assets/img/bg/akd.png')}}" alt="Preloader">
                </div>
            </div>
        </div>
    </div>
    <!--Preloader-end -->
    <!-- Scroll-top -->
    <button class="scroll__top scroll-to-target" data-target="html">
        <i class="fas fa-angle-up"></i>
    </button>
    <!-- Scroll-top-end-->
    <!-- header-area -->
    @include('layouts.header')
    <!-- header-area-end -->
    <!-- main-area -->
    <main class="fix">
        @yield('content')
        @if(session('success'))
        <script>
            toastr.success("{{ session('success') }}");
        </script>
    @endif
    @if($errors->any())
        @foreach($errors->all() as $error)
            <script>
                toastr.error("{{ $error }}");
            </script>
        @endforeach
    @endif
    </main>

    @include('layouts.footer')
    @include('components.gdpr-notice')
    <!-- JS here -->
    <script src="{{asset('assets/js/vendor/jquery-3.6.0.min.js')}}"></script>
    <script src="{{asset('assets/js/bootstrap.bundle.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.magnific-popup.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.odometer.min.js')}}"></script>
    <script src="{{asset('assets/js/jquery.appear.js')}}"></script>
    <script src="{{asset('assets/js/gsap.js')}}"></script>
    <script src="{{asset('assets/js/ScrollTrigger.js')}}"></script>
    <script src="{{asset('assets/js/SplitText.js')}}"></script>
    <script src="{{asset('assets/js/gsap-animation.js')}}"></script>
    <script src="{{asset('assets/js/jquery.parallaxScroll.min.js')}}"></script>
    <script src="{{asset('assets/js/swiper-bundle.js')}}"></script>
    <script src="{{asset('assets/js/ajax-form.js')}}"></script>
    <script src="{{asset('assets/js/wow.min.js')}}"></script>
    <script src="{{asset('assets/js/aos.js')}}"></script>
    <script src="{{asset('assets/js/main.js')}}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
        <!-- Swiper JS -->
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
    <script>
        const text = document.querySelector('.circle');
        text.innerHTML = text.textContent.replace(/\S/g, "<span>$&</span>");
        const element = document.querySelectorAll('.circle span');
        for (let i = 0; i < element.length; i++) {
            element[i].style.transform = "rotate(" + i * 17 + "deg)"
        }
    </script>
    @yield('script')
</body>

</html>
