@extends('layouts.app')
@section('css')

 @section('title')
 Amerikan Kültür Kurumsal
 @endsection
 @section('content')

 <section class="breadcrumb__area breadcrumb__bg"  data-background="assets/img/akdweb.jpg">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="breadcrumb__content">
                    <h2 class="title">{{__('Our References')}}</h2>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">{{__('Home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('Our References')}}</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <div class="breadcrumb__shape">
        <img src="assets/img/images/breadcrumb_shape05.png" alt="" class="alltuchtopdown">
    </div>
</section>



<div class="container my-5">
    <div class="row">
        <div class="col-12">
            <br>
            <br>
            <h2 class="text-center" style="color:#E30613">{{ __('Our References') }}</h2>
            <br>
            <p class="text-center">{{ __('Turkey\'s largest companies prefer us in corporate english.') }} <br> {{__('Our trainings contribute to the success of your company and support your employees to communicate more confidently and effectively in business life.') }}</p>
        </div>
    </div>


    <br>
    <br>
    <div class="row">
        @foreach ($reference as $reference)
        <div class="col-xl-3 col-lg-4 col-md-6">
            <div class="reference-card">
                <br>
                @if($reference->image)
                <img src="{{ config('app.storage') . $reference->image }}" alt="{{ $reference->name }}">
                @else
                <svg width="145" height="28" viewBox="0 0 145 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="145" height="28" style="fill:#ccc;"></rect>
                </svg>
                @endif
            </div>
        </div>
        @endforeach
    </div>
</div>

<style>
  

    </style>


<section class="call-back-area" style="background-image: url('assets/img/newslider.jpg'); background-size: cover; background-position: center;">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="call-back-content">
                    <div class="section-title white-title mb-10 tg-heading-subheading animation-style3">
                        <h2 class="title tg-element-title">{{__('f2')}}</h2>
                    </div>
                    <br>
                    <p>{{__('f1')}}</p>
                    <div class="shape">
                        <img src="assets/img/images/call_back_shape.png" alt="" data-aos="fade-right" data-aos-delay="400">
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="call-back-form">
                  <form action="{{ route('quote.store') }}" method="POST">
                 
                  @csrf
                  <input type="hidden" name="visit_time" value="{{ time() }}">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-grp">
                                 <input type="text" name="name" placeholder="{{__('Name-Surname')}}*" required>
                              </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-grp">
                                    <input type="text" name="phone" placeholder="{{__('Phone')}}*" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-grp">
                                   <input type="email" name="email" placeholder="{{__('Corporate Email')}}*" required>
                                </div>
                            
                                <input type="checkbox" name="sozlesmeonay" value="1" id="sozlesmeonay" required>
                                <label for="sozlesmeonay"> {{__('I agree to the KVKK contract')}}</label>
                                
                                
                          
                            </div>
                            <div class="col-md-6">
                                <button type="submit" class="btn">{{__('Submit')}}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        $('#katilimciForm').on('submit', function(event) {
            event.preventDefault(); // Sayfa yenilemesini önler
            var formData = $(this).serialize();

            $.ajax({
                url: $(this).attr('action'),
                method: $(this).attr('method'),
                data: formData,
                success: function(response) {
                    $('#alert-container').html(
                        '<div class="alert alert-info custom-alert" role="alert">' +
                        'Bilgileriniz başarıyla gönderildi!' +
                        '</div>'
                    );
                    setTimeout(function() {
                        $('.custom-alert').fadeOut('slow', function() {
                            $(this).remove();
                        });
                    }, 10000); 
                },
                error: function(xhr) {
                    $('#alert-container').html(
                        '<div class="alert alert-danger custom-alert" role="alert">' +
                        'Bir hata oluştu. Lütfen tekrar deneyin.' +
                        '</div>'
                    );
                    setTimeout(function() {
                        $('.custom-alert').fadeOut('slow', function() {
                            $(this).remove();
                        });
                    }, 10000); 
                }
            });
        });
    });
</script>
</section>


@endsection
