@extends('layouts.app')
@section('css')
@endsection
@section('title')
    Amerikan Kültür Kurumsal
@endsection
@section('content')
    <section class="breadcrumb__area breadcrumb__bg" data-background="assets/img/akdweb.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="breadcrumb__content">
                        <h2 class="title">{{ __('Corporate English Education Program') }}</h2>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Home') }}</a></li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    {{ __('Corporate English Education Program') }}</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <div class="breadcrumb__shape">
            <img src="assets/img/images/breadcrumb_shape05.png" alt="" class="alltuchtopdown">
        </div>
    </section>

    <section class="team__area-three marketing__area-home8">

        <div class="container">
            <div class="row align-items-center">
                <div class="col-xl-7 col-lg-6 mb-50">
                    <div class="section-title tg-heading-subheading animation-style3">
                        <span class="sub-title">{{ __('Corporate English Education Program') }}</span>
                        <h2 class="title tg-element-title">
                            {{ __('Make Your Company Stronger with Professional English Programmes!') }}</h2>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-6 mb-50">
                    <div class="section-content">
                        <span class="sub-title"
                            style="font-weight: 600">{{ __('Dear Company Owners and Managers,') }}</span>
                        <br>
                        <br>
                        <p>{{ __('As Corporate American Culture Language Courses, we are proud to offer you the Corporate English Training Package specially designed for your company to become stronger in the international arena and for your employees to improve their language skills. This training package attracts attention with its rich content and special advantages tailored to the needs of companies.') }}
                        </p>
                    </div>
                </div>
            </div>
            <div class="row gutter-24">
                @foreach ($whyuse as $item)
                    <div class="col-xl-4 col-lg-4 col-md-6 d-flex">
                        <div class="card-services-type-01">
                            <div class="card-icon">
                                <img src="{{ asset('assets/img/icon/akd.ico') }}" alt="Amerikan Kultur">
                            </div>
                            <div class="card-info">
                                <h5>{{ $item->question }}</h5>
                                <p>{{ $item->answer }}</p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
    </section>
@endsection
