<?php

namespace Tests\Unit\Jobs;

use Tests\TestCase;
use App\Jobs\SendQuoteEmail;
use App\Mail\ParticipantMail;
use Illuminate\Support\Facades\Mail;

class SendQuoteEmailTest extends TestCase
{
    protected function setUp(): void
    {
        parent::setUp();
        Mail::fake();
    }

    /** @test */
    public function it_sends_email_to_admin()
    {
        $quoteData = [
            'AdSoyad' => 'Test User',
            'SirketAdi' => 'Test Company',
            'Telefon' => '5551234567',
            'Email' => 'test@example.com',
            'Mesaj' => 'Test message'
        ];

        $job = new SendQuoteEmail($quoteData);
        $job->handle();

        Mail::assertSent(ParticipantMail::class, function ($mail) use ($quoteData) {
            return $mail->hasTo(config('mail.admin_email')) &&
                   $mail->quoteData['AdSoyad'] === $quoteData['AdSoyad'];
        });
    }
}
